
DROP FUNCTION IF EXISTS [dbo].[fn_TitleCase] 
GO
/*********************************************
Capitalizes first letter of specified string
*********************************************/
CREATE FUNCTION [dbo].[fn_TitleCase] 
( 
	--string need to format
	@inputString NVARCHAR(MAX)--increase the variable size depending on your needs.                                             
)
RETURNS NVARCHAR(MAX)
WITH SCHEMABINDING
AS
BEGIN

    DECLARE @index INT
    DECLARE @c NCHAR(1)
    DECLARE @outputString NVARCHAR(MAX)

	IF (@inputString IS NULL) RETURN ''

    SET @index = 2
    SET @outputString = LOWER(@inputString)
    SET @outputString = STUFF(@outputString, 1, 1, UPPER(SUBSTRING(@inputString, 1, 1)))
    
	WHILE @index <= LEN(@inputString)
        BEGIN
            SET @c = SUBSTRING(@inputString, @index, 1)

			-- capitalize letter after following characters...
            IF @c IN ( ' ', ';', ':', '!', '?', ',', '.', '_', '-', '/', '&', '''', '(', CHAR(10), CHAR(13) )

                IF @index + 1 <= LEN(@inputString)
                    BEGIN
                        IF @c != ''''
                            OR UPPER(SUBSTRING(@inputString, @index + 1, 1)) != 'S'
                            SET @outputString = 
								STUFF(@outputString, @index + 1, 1, UPPER(SUBSTRING(@inputString, @index + 1, 1)))
                    END

            SET @index = @index + 1
        END

    RETURN  ISNULL(@outputString, '')
END


GO





DROP FUNCTION IF EXISTS [dbo].[tvf_TitleCase] 
GO
CREATE FUNCTION [dbo].[tvf_TitleCase] 
(
	@InputString varchar(2000)
)
RETURNS TABLE 
AS
RETURN 
(

	/* -- Testing Code
	DECLARE @InputString VARCHAR(2000) = 'abc sw 123 disney World Johnson''s, :String ;special,
	testing jonathan''s function test';
	SELECT *
	FROM dbo.tvf_TitleCase(@InputString) 
	SELECT *
	FROM dbo.tvf_TitleCase(NULL)
	*/

	-- Use a table of numbers to make string cleaner faster for performance
	WITH num_cte AS (
		SELECT number AS N 
		FROM master..spt_values 
		WHERE type = 'P'

	), rawdata AS (
		SELECT N, SUBSTRING(ISNULL(@InputString,''), N, 1) AS pos_char 
		FROM num_cte WHERE N<=LEN(@InputString)
	)
	SELECT ISNULL((
		SELECT CASE
			WHEN a.pos_char = 's' AND b.pos_char = '''' 
				THEN a.pos_char 
			WHEN b.pos_char IN ( ' ', ';', ':', '!', '?', ',', '.', '_', '-', '/', '&', '''', '(', CHAR(10), CHAR(13), CHAR(9) )
				THEN UPPER(a.pos_char) 
			ELSE LOWER(a.pos_char) 	--ELSE a.pos_char 
		END  
		FROM rawdata AS a 
		LEFT JOIN rawdata AS b ON b.N = a.N-1
		WHERE a.N > 0
		FOR XML PATH(''), TYPE 
	).value('.', 'varchar(2000)'), '') AS OutputString
)


GO